return Def.ActorFrame{
  Name= "xtl_actor_wi",
  InitCommand= function(self)
		-- these should be initialised as early as possible
		m_i = {} -- main table
		m_i.c2l = {} -- chart to lua tables
		m_i.fakes = {}
		m_i.fps = 1 / 50
		m_i.firstseenbeat = GAMESTATE:GetSongBeat()
		m_i.path = GAMESTATE:GetCurrentSong():GetSongDir()

		m_i.players = {} -- table that contains players and elements
		m_i.origins = {} -- table that contains original values of players and elements

		for pn = 1, 2 do
			table.insert(m_i.players, {}) -- add a table in the players table for players 1 to 8
			table.insert(m_i.origins, {}) -- add a table in the origins table for players 1 to 8
		end
		self:sleep(9E9)
	end,
  Def.Quad{
    Name= "xtl_actor_xi",
    InitCommand= cmd(visible,false),
    OnCommand= function(self)

			-- functions start --

			m_i.insert = function(act1, act2, act3, act4)
				table.insert(mod_actions, {act1, act2, act3, act4})
			end

			m_i.mod = function(act1, act2, act3, act4, act5)
				table.insert(mods, {act1, act2, act3, act4, act5})
			end

			m_i.ease = function(act1, act2, act3, act4, act5, act6, act7, act8, act9, act10, act11)
				mod_ease(act1, act2, act6, act7, act3, act5, act4, act8, act9, act10, act11)
			end

			m_i.bps = function()
				return 60 / (GAMESTATE:GetCurBPS() * 60)
			end

			-- function ebd

			local l, e = 'len', 'end'

			m_i.ease(108, 4, 'dizzy', outBack, l, 200, 0)
			m_i.ease(112, 4, 'dizzy', outBack, l, 200, 0)

			m_i.mod(120, 0.1, '*10000 200 dizzy', l)
			m_i.ease(120, 4, 'dizzy', outBack, l, -200, 20)
			m_i.ease(120, 2, 'tornaDO', outBack, l, 0, 50)
			m_i.ease(122, 4, 'tornaDO', outBack, l, 50, 0)

			local selection = {'reverse', 'split', 'alternate', 'cross'}
			m_i.ease(116, 2, selection[math.random(table.getn(selection))], outBack, l, 100, 0)
			m_i.ease(116, 2, selection[math.random(table.getn(selection))], outBack, l, 100, 0)
			m_i.ease(116, 2, selection[math.random(table.getn(selection))], outBack, l, 100, 0)

			for beat = 124, 216, 8 do
				m_i.ease(beat, 4, 'dizzy', inOutSine, l, 20, -20)
				m_i.ease(beat + 4, 4, 'tornado', inOutSine, l, -20, 20)
				m_i.ease(beat, 4, 'tornado', inOutElastic, l, 40, 0)
				m_i.ease(beat + 4, 4, 'dizzy', inOutElastic, l, 0, 40)
			end

			local flux = 1
			for beat = 97, 103 do
				m_i.ease(beat + 0.5, 0.25, 'dizzy', linear, l, -200 * flux, 200 * flux)
				m_i.ease(beat + 0.75, 0.25, 'dizzy', linear, l, 200 * flux, -200 * flux)
				m_i.ease(beat + 1, 0.25, 'dizzy', linear, l, -200 * flux, 200 * flux)
				flux = -flux
			end

			m_i.ease(155, 2, 'bumpy', outBack, l, 3000, 0)

			self:queuecommand('Set')
		end,
    SetCommand= function(self)		
			-- name players, judgment, combo and notefield
			-- m_i.players[<pn>].<element> to grab players, judgment, combo, and NoteField
			-- m_i.origins[<pn>].<element>.<origin> to grab the original value of <origin> at beat 0
			-- pn = 1 to 2
			--
			-- elements:
			--	p	= Player
			--	jud = Judgment
			--	com = Combo
			--	n	= Notefield
			--	proxies
			--		p[n]	= nth player proxy in table
			--		jud[n]	= nth judgment proxy in table
			--		com[n]	= nth combo proxy in table
			--
			-- origins:
			--	x
			--	y
			--	z
			--	zoom

			-- this is very table hell

			local screen = SCREENMAN:GetTopScreen() -- shortcut to grab the topscreen
			local origin_to_grab = {{'x', 'GetX'}, {'y', 'GetY'}, {'z', 'GetZ'}, {'zoom', 'GetZoom'}} -- list names and function names to use to get the original position of elements

			for pn = 1, 2 do

				if screen:GetChild('PlayerP' .. pn) then -- check if the players exist, otherwise don't do anything that touches the players themselves
					local elements_to_grab = { -- list elements, and names to grab them
						{screen:GetChild('PlayerP' .. pn), 'p'},
						{screen:GetChild('PlayerP' .. pn):GetChild('Judgment'), 'jud'},
						{screen:GetChild('PlayerP' .. pn):GetChild('Combo'), 'com'},
					}

					for cur_element, element in pairs(elements_to_grab) do
						m_i.players[pn][element[2]] = element[1] -- name and assign each variable for player related elements
						m_i.origins[pn][element[2]] = {} -- table that will hold values for original values of specific of each element to each player

						for cur_origin, origin in pairs(origin_to_grab) do
							m_i.origins[pn][element[2]][origin[1]] = loadstring('return ' .. 'm_i.players[' .. pn .. '].' .. element[2] .. ':' .. origin[2] .. '()') -- save the original values
							m_i.origins[pn][element[2]][origin[1]] = m_i.origins[pn][element[2]][origin[1]]() -- removes the () from the variables
						end
					end
				end
			end
		end,
  },
}
